\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{snpsg}[2025-11-20 SNPSG Journal class]
\LoadClass[10pt,twocolumn]{article}
\RequirePackage[
letterpaper,
top=1.78cm,
bottom=1.78cm,
left=1.65cm,
right=1.65cm,
headsep=3pt,
footskip=28pt,
headheight=50pt,
]{geometry}
\RequirePackage{xurl}
\urlstyle{rm}
\RequirePackage{graphicx}
\RequirePackage{times}
\RequirePackage{hyphenat}
\RequirePackage{xcolor}
\RequirePackage{setspace}
\setstretch{0.96}
\NewDocumentCommand{\am}{m}{\textsuperscript{#1}}
\NewDocumentCommand{\affiliation}{m}{\NewDocumentCommand{\@affiliation}{}{#1}}
\NewDocumentCommand{\corrauthor}{m}{\NewDocumentCommand{\@corrauthor}{}{#1}}
\NewDocumentCommand{\email}{m}{\NewDocumentCommand{\@email}{}{#1}}
\DeclareDocumentCommand{\abstract}{+m}{\NewDocumentCommand{\@abstract}{}{#1}}
\NewDocumentCommand{\keywords}{m}{\NewDocumentCommand{\@keywords}{}{#1}}
\newif\ifCLASSOPTIONreview\CLASSOPTIONreviewtrue
\NewDocumentCommand{\@received}{}{}
\NewDocumentCommand{\received}{m}{\ifCLASSOPTIONreview\relax\else\RenewDocumentCommand{\@received}{}{#1}\fi}
\NewDocumentCommand{\@footyear}{}{}
\NewDocumentCommand{\footyear}{m}{\ifCLASSOPTIONreview\relax\else\RenewDocumentCommand{\@footyear}{}{#1}\fi}
\NewDocumentCommand{\@footleft}{}{}
\NewDocumentCommand{\footleft}{m}{\ifCLASSOPTIONreview\relax\else\RenewDocumentCommand{\@footleft}{}{#1}\fi}
\NewDocumentCommand{\@firstfootleft}{}{}
\NewDocumentCommand{\firstfootleft}{m}{\ifCLASSOPTIONreview\relax\else\RenewDocumentCommand{\@firstfootleft}{}{#1}\fi}
\NewDocumentCommand{\@headright}{}{}
\NewDocumentCommand{\headright}{m}{\ifCLASSOPTIONreview\relax\else\RenewDocumentCommand{\@headright}{}{#1}\fi}
\NewDocumentCommand{\@firstheadright}{}{}
\NewDocumentCommand{\firstheadright}{m}{\ifCLASSOPTIONreview\relax\else\RenewDocumentCommand{\@firstheadright}{}{#1}\fi}
\DeclareOption{review}{
\CLASSOPTIONreviewtrue
\received{}
\footyear{}
\footleft{}
\firstfootleft{}
\headright{}
\firstheadright{}
}
\DeclareOption{final}{
\CLASSOPTIONreviewfalse
\received{Received: DD Month YYYY $|$ Revised: DD Month YYYY $|$ Accepted: DD Month YYYY $|$ Published online: DD Month YYYY}
\footyear{YEAR}
\footleft{Journal Name, Year, Vol. X(X) xxx--xxx}
\firstfootleft{© \@footyear{} The Author(s). Published by Spectrum Nexus Publishing (SNP). This is an open access article under the CC BY 4.0 License\\(\url{https://creativecommons.org/licenses/by/4.0/}).}
\headright{DOI: \url{https://doi.org/10.xxxx/xxxx.xxxx}}
\firstheadright{2025, Vol. 2(3) 100--109\\DOI: \url{https://doi.org/10.xxxx/xxxx.xxxx}}
}
\ExecuteOptions{review}
\ProcessOptions
\definecolor{logored}{RGB}{239,51,64}
\DeclareDocumentCommand{\maketitle}{}{
\twocolumn[\@maketitle]
}
\DeclareDocumentCommand{\@maketitle}{}{
\begin{spacing}{1}
{\fontsize{14pt}{14pt}\selectfont\itshape\textcolor{logored}{RESEARCH ARTICLE}\par}
{\fontsize{20pt}{24pt}\selectfont\boldmath\bfseries\ignorespaces\nohyphens{\@title}\par}\addvspace{8pt}
{\fontsize{10pt}{12pt}\selectfont\boldmath\bfseries\ignorespaces\@author\par}
{\fontsize{10pt}{12pt}\selectfont\itshape\ignorespaces\@affiliation\par}
{\fontsize{10pt}{12pt}\selectfont * Corresponding author(s): \ignorespaces\@corrauthor\par}
{\fontsize{10pt}{12pt}\selectfont Email(s): \ignorespaces\@email\par}\addvspace{5pt}
{\fontsize{9pt}{10.8pt}\selectfont\@received\par}\addvspace{5pt}
\rule[3pt]{\textwidth}{1pt}
{\fontsize{9pt}{10.8pt}\selectfont {\bfseries\itshape Abstract:} \ignorespaces\@abstract\par}\addvspace{3pt}
{\fontsize{9pt}{10.8pt}\selectfont\boldmath\bfseries\itshape Keywords: \ignorespaces\@keywords\par}
\rule[3pt]{\textwidth}{1pt}\addvspace{8pt}
\end{spacing}
}
\renewcommand{\figurename}{Fig.}
\renewcommand{\tablename}{Table}
\RequirePackage{caption}
\DeclareCaptionLabelSeparator{customskip}{\hspace{5pt}}
\captionsetup[figure]{
font=small,
labelfont=bf,
labelsep=customskip,
format=plain,
position=bottom,
skip=5pt,
}
\captionsetup[table]{
font=small,
labelfont=bf,
labelsep=customskip,
format=plain,
position=top,
skip=5pt,
}
\captionsetup[subfigure]{
font=footnotesize,
labelfont=bf,
labelsep=space,
format=plain,
position=bottom,
skip=3pt,
}
\setlength{\floatsep}{8pt plus 2pt minus 2pt}
\setlength{\intextsep}{8pt plus 2pt minus 2pt}
\setlength{\textfloatsep}{8pt plus 2pt minus 2pt}
\bibliographystyle{IEEEtran}
\RequirePackage{indentfirst}
\RequirePackage{titlesec}
\setcounter{secnumdepth}{4}
\titleformat{\section}
{\fontsize{10pt}{12pt}\selectfont\boldmath\bfseries\itshape}
{\Roman{section}.}
{.5em}
{}
\titleformat{\subsection}
{\fontsize{10pt}{12pt}\selectfont\itshape}
{\Alph{subsection}.}
{.5em}
{}
\titleformat{\subsubsection}
{\fontsize{10pt}{12pt}\selectfont\itshape}
{\arabic{section})}
{.5em}
{}
\titleformat{\paragraph}
{\fontsize{10pt}{12pt}\selectfont\itshape}
{\alph{paragraph})}
{.5em}
{}
\titlespacing{\section}{0pt}{12pt plus 2pt minus 2pt}{4pt plus 2pt minus 2pt}
\titlespacing{\subsection}{0pt}{5pt plus 2pt minus 2pt}{3pt plus 2pt minus 2pt}
\titlespacing{\subsubsection}{0pt}{5pt plus 2pt minus 2pt}{3pt plus 2pt minus 2pt}
\titlespacing{\paragraph}{0pt}{5pt plus 2pt minus 2pt}{3pt plus 2pt minus 2pt}
\RequirePackage{fancyhdr}
\NewDocumentCommand{\startpage}{m}{\ifCLASSOPTIONreview\relax\else\setcounter{page}{#1}\fi}
\definecolor{rulegray}{RGB}{127,127,127}
\fancypagestyle{firstpage}{
\fancyhf{}
\renewcommand{\headrule}{{\color{logored}\rule[4pt]{\headwidth}{4pt}}}
\renewcommand{\footrule}{{\color{rulegray}\rule[4pt]{\headwidth}{1pt}}}
\fancyhead[L]{\includegraphics[height=.7cm]{logo.pdf}}
\fancyhead[C]{}
\fancyhead[R]{\fontsize{8pt}{8pt}\selectfont\@firstheadright}
\fancyfoot[L]{\fontsize{8pt}{8pt}\selectfont\@firstfootleft}
\fancyfoot[C]{}
\fancyfoot[R]{\fontsize{8pt}{8pt}\selectfont\arabic{page}}
}
\fancypagestyle{otherpages}{
\fancyhf{}
\renewcommand{\headrule}{{\color{black}\rule[4pt]{\headwidth}{1pt}}}
\renewcommand{\footrule}{{\color{rulegray}\rule[4pt]{\headwidth}{1pt}}}
\fancyhead[L]{\fontsize{14pt}{14pt}\selectfont\itshape Research Article}
\fancyhead[C]{}
\fancyhead[R]{\fontsize{8pt}{8pt}\selectfont\@headright}
\fancyfoot[L]{\fontsize{8pt}{8pt}\selectfont\@footleft}
\fancyfoot[C]{}
\fancyfoot[R]{\fontsize{8pt}{8pt}\selectfont\arabic{page}}
}
\pagestyle{otherpages}
\thispagestyle{firstpage}
\RequirePackage[numbers,sort&compress]{natbib}
\renewcommand{\bibfont}{\small}
\setlength{\bibsep}{3pt}
\RequirePackage{orcidlink}
\setcounter{totalnumber}{9}
\setcounter{topnumber}{9}
\setcounter{bottomnumber}{9}
\renewcommand{\topfraction}{.95}
\renewcommand{\textfraction}{.05}
\renewcommand{\floatpagefraction}{.95}
